#*************************************************************************
#	> File Name: ASWork4_TlinP3.py
#	> Author: Bugatti100Peagle 
#	> Mail: 3443988515@qq.com
#	> Created Time: 2018/4/30 22:05:19
 #************************************************************************/
#!/usr/bin/env python
# coding=utf-8

import sys, os 
import numpy as np
import matplotlib.pyplot as plt
#-------常数声明-------
Kd = 0.286
P00 = 1000 
Cpd = 1004
Lv = 2.5* 10**6 # J·kg-1
ee = 0.622
# y=-LnP x=T
#--------范围声明-------
theta=np.arange(-60,190,10)
T = np.arange(-80,45,5)
qs = [0.05, 0.1, 0.2, 0.5, 1, 1.5, 2, 3, 4, 6, 8, 12, 16, 20, 24, 30]

#-----------文件名-----
selfname = os.path.basename(sys.argv[0])
selfname = selfname[:-3]  #去掉.py后缀名

#----------计算---------
X = T   #用于作图不用于计算
T = T + 273.15

#---------函数--------
def es(t_f):
    es = 6.1078*np.exp(17.2693882*(t_f-273.16)/(t_f-35.86))
    return es
#----------T_LnP的计算函数-------
def fqs(t_f, p_f):
    fqs = ee*es(t_f)/p_f
    return fqs

def theta_weiwen(t_f, P_f):
    theta_weiwen = t_f*(P00/P_f)**Kd
    return theta_weiwen

def thetase_jiaweiwen(t_f, P_f):
    thetase_jiaweiwen = (theta_weiwen(t_f, P_f))*np.exp(Lv*fqs(t_f, P_f)/(Cpd*t_f))
    return thetase_jiaweiwen
#----------T_LnP的计算函数，也可以在后面调用时在转换Y值，此处为了逻辑清晰单独列出-----
def Lnfqs(t_f, LnP_f):
    P_f = np.exp(LnP_f)
    Lnfqs = ee*es(t_f)/P_f
    return Lnfqs
def Lntheta_weiwen(t_f, LnP_f):
    P_f = np.exp(LnP_f)
    Lntheta_weiwen = t_f*(P00/P_f)**Kd
    return Lntheta_weiwen

def Lnthetase_jiaweiwen(t_f, LnP_f):
    P_f = np.exp(LnP_f)
    Lnthetase_jiaweiwen = (theta_weiwen(t_f, P_f))*np.exp(Lv*fqs(t_f, P_f)/(Cpd*t_f))
    return Lnthetase_jiaweiwen


plt.figure(figsize=(60, 42))  #T-P
Pnum = np.arange(200, 1100, 10)    
X_P, Y_P = np.meshgrid(T, Pnum)
#等高线绘图
JWW = plt.contour(X_P-273.15, Y_P, thetase_jiaweiwen(X_P, Y_P)-273.15, list(theta), colors='red')
WW = plt.contour(X_P-273.15, Y_P, theta_weiwen(X_P, Y_P)-273.15, list(theta), colors='green')
QS = plt.contour(X_P-273.15, Y_P, 1000*fqs(X_P, Y_P), list(qs), colors='darkgoldenrod')
plt.plot([-80,40], [622, 622], color='blue', linewidth=1.5, linestyle="--")
# =============================================================================
# 参考此文档设置特定值的等高线
# https://stackoverflow.com/questions/28126678/contour-labels-in-python
# =============================================================================
plt.clabel(JWW, inline = 1, fontsize = 30, fmt='%1.0f')
plt.clabel(WW, inline = 1, fontsize = 30, fmt='%1.0f')
plt.clabel(QS, inline = 1, fontsize = 30)
#画图例，取值没有特定含义
plt.plot(0, 0, 'g', label=r'$\theta$')
plt.plot(0, 0, 'r', label=r'$ \theta_{es}$')
plt.plot(0, 0, 'darkgoldenrod', label='qs')  
plt.grid(True)
plt.xlabel(r'$Temperature (^\circ C)$', size=40)
plt.ylabel(r'$Pressure (hPa)$', size=40, rotation=90)
plt.title(r'T$-P $', size=40)
plt.xticks(X,size=40)
plt.yticks(size=40)

#反转坐标轴
plt.ylim(1000,200)

#修改图例的大小
plt.legend(loc=0, numpoints=1)
leg = plt.gca().get_legend()
ltext = leg.get_texts()
plt.setp(ltext, fontsize=40)
#保存图片
selfname1= "../" + selfname + "T-P3.png"
plt.savefig(selfname1)


plt.figure(figsize=(60, 42))  #T-LnP
Pnum = np.arange(200, 1100, 100)    
X_P, LnY_P = np.meshgrid(T, np.log(Pnum))
LnJWW = plt.contour(X_P-273.15, LnY_P, Lnthetase_jiaweiwen(X_P, LnY_P)-273.15, list(theta), colors='red')
LnWW = plt.contour(X_P-273.15, LnY_P, Lntheta_weiwen(X_P, LnY_P)-273.15, list(theta), colors='green')
LnQS1 = plt.contour(X_P-273.15, LnY_P, 1000*Lnfqs(X_P, LnY_P), [0.05], colors='darkgoldenrod') #*1000 转换单位 g/Kg
LnQS2 = plt.contour(X_P-273.15, LnY_P, 1000*Lnfqs(X_P, LnY_P), list(qs[1:4]), colors='darkgoldenrod') #*1000 转换单位 g/Kg
LnQS3 = plt.contour(X_P-273.15, LnY_P, 1000*Lnfqs(X_P, LnY_P), list(qs[4:]), colors='darkgoldenrod') #*1000 转换单位 g/Kg
plt.plot([-80,40], [np.log(622), np.log(622)], color='blue', linewidth=1.5, linestyle="--")
# =============================================================================
# 参考此文档设置特定值的等高线
# https://stackoverflow.com/questions/28126678/contour-labels-in-python
# =============================================================================
plt.clabel(LnJWW, inline = 1, fontsize = 30, fmt='%1.0f')
plt.clabel(LnWW, inline = 1, fontsize=30, fmt='%1.0f')
#用字号大小区分重叠的标注值
plt.clabel(LnQS1, inline = 1, fontsize = 60, fmt='%1.2f')
plt.clabel(LnQS2, inline = 1, fontsize = 60, fmt='%1.1f')
plt.clabel(LnQS3, inline = 1, fontsize = 60, fmt='%1.0f')

plt.plot(0, 0, 'g', label=r'$\theta$')
plt.plot(0, 0, 'r', label=r'$\theta_{es}$')
plt.plot(0, 0, 'darkgoldenrod', label='qs')  


YTValue = [200, 250, 300, 400, 500, 600, 622, 700, 850, 925, 1000]
YTChar =  ['40 & 200', '50 & 250', '60 & 300', '80 & 400', '100 & 500', '120 & 600', '622', '140 & 700', '170 & 850', '185 & 925', '200 & 1000']
Yticks = np.log(YTValue)
plt.yticks(Yticks, YTChar, size=40) #用P代替LnP
plt.xticks(X,size=40)
plt.grid(True)
plt.xlabel(r'$Temperature (^\circ C)$', size=40)
plt.ylabel(r'$Pressure (hPa)$', size=40, rotation=90)
plt.title(r'T$-LnP $', size=40)

plt.ylim(np.log(1000),np.log(200))

plt.legend(loc=0, numpoints=1)
leg = plt.gca().get_legend()
ltext = leg.get_texts()
plt.setp(ltext, fontsize=40)

selfname2 = "../" + selfname + "T-LnP3.png"
plt.savefig(selfname2)

#plt.show()